/*
 * Decompiled with CFR 0.152.
 */
package net.qualityequipment.network;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.qualityequipment.QualityEquipmentMod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class QualityEquipmentModVariables {
    public static final Capability<PlayerVariables> PLAYER_VARIABLES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<PlayerVariables>(){});

    @SubscribeEvent
    public static void init(FMLCommonSetupEvent event) {
        QualityEquipmentMod.addNetworkMessage(SavedDataSyncMessage.class, SavedDataSyncMessage::buffer, SavedDataSyncMessage::new, SavedDataSyncMessage::handler);
        QualityEquipmentMod.addNetworkMessage(PlayerVariablesSyncMessage.class, PlayerVariablesSyncMessage::buffer, PlayerVariablesSyncMessage::new, PlayerVariablesSyncMessage::handler);
    }

    @SubscribeEvent
    public static void init(RegisterCapabilitiesEvent event) {
        event.register(PlayerVariables.class);
    }

    public static class SavedDataSyncMessage {
        public int type;
        public SavedData data;

        public SavedDataSyncMessage(FriendlyByteBuf buffer) {
            this.type = buffer.readInt();
            SavedData savedData = this.data = this.type == 0 ? new MapVariables() : new WorldVariables();
            if (savedData instanceof MapVariables) {
                MapVariables _mapvars = (MapVariables)savedData;
                _mapvars.read(buffer.m_130260_());
            } else {
                savedData = this.data;
                if (savedData instanceof WorldVariables) {
                    WorldVariables _worldvars = (WorldVariables)savedData;
                    _worldvars.read(buffer.m_130260_());
                }
            }
        }

        public SavedDataSyncMessage(int type, SavedData data) {
            this.type = type;
            this.data = data;
        }

        public static void buffer(SavedDataSyncMessage message, FriendlyByteBuf buffer) {
            buffer.writeInt(message.type);
            buffer.m_130079_(message.data.m_7176_(new CompoundTag()));
        }

        public static void handler(SavedDataSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    if (message.type == 0) {
                        MapVariables.clientSide = (MapVariables)message.data;
                    } else {
                        WorldVariables.clientSide = (WorldVariables)message.data;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariablesSyncMessage {
        public PlayerVariables data;

        public PlayerVariablesSyncMessage(FriendlyByteBuf buffer) {
            this.data = new PlayerVariables();
            this.data.readNBT((Tag)buffer.m_130260_());
        }

        public PlayerVariablesSyncMessage(PlayerVariables data) {
            this.data = data;
        }

        public static void buffer(PlayerVariablesSyncMessage message, FriendlyByteBuf buffer) {
            buffer.m_130079_((CompoundTag)message.data.writeNBT());
        }

        public static void handler(PlayerVariablesSyncMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> {
                if (!context.getDirection().getReceptionSide().isServer()) {
                    PlayerVariables variables = (PlayerVariables)Minecraft.m_91087_().f_91074_.getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
                    variables.sword = message.data.sword;
                    variables.ingot = message.data.ingot;
                    variables.update1 = message.data.update1;
                    variables.update2 = message.data.update2;
                    variables.successhammer = message.data.successhammer;
                    variables.successhammer2 = message.data.successhammer2;
                    variables.attackattribute = message.data.attackattribute;
                    variables.potiontrigger = message.data.potiontrigger;
                    variables.attackspeed = message.data.attackspeed;
                    variables.amount = message.data.amount;
                    variables.guireset = message.data.guireset;
                    variables.guiopenagain = message.data.guiopenagain;
                    variables.shieldchecker = message.data.shieldchecker;
                    variables.shieldspeedsave = message.data.shieldspeedsave;
                    variables.shieldchecker2 = message.data.shieldchecker2;
                    variables.shieldchecker3 = message.data.shieldchecker3;
                    variables.helmspeedsaver = message.data.helmspeedsaver;
                    variables.jumpheight = message.data.jumpheight;
                    variables.springytrigger = message.data.springytrigger;
                    variables.chestspeedsaver = message.data.chestspeedsaver;
                    variables.legspeedsaver = message.data.legspeedsaver;
                    variables.bootspeedsaver = message.data.bootspeedsaver;
                    variables.invchecker = message.data.invchecker;
                    variables.bowclumsy = message.data.bowclumsy;
                    variables.held = message.data.held;
                    variables.bowlight = message.data.bowlight;
                    variables.bowcracked = message.data.bowcracked;
                    variables.bowpowerful = message.data.bowpowerful;
                    variables.bowlegendary = message.data.bowlegendary;
                    variables.worthlessname = message.data.worthlessname;
                    variables.worthlessstat1 = message.data.worthlessstat1;
                }
            });
            context.setPacketHandled(true);
        }
    }

    public static class PlayerVariables {
        public double sword = 0.0;
        public double ingot = 0.0;
        public double update1 = 0.0;
        public double update2 = 0.0;
        public boolean successhammer = false;
        public boolean successhammer2 = false;
        public double attackattribute = 0.0;
        public boolean potiontrigger = false;
        public boolean attackspeed = false;
        public double amount = 0.0;
        public boolean guireset = false;
        public boolean guiopenagain = false;
        public boolean shieldchecker = false;
        public double shieldspeedsave = 0.0;
        public boolean shieldchecker2 = false;
        public boolean shieldchecker3 = false;
        public double helmspeedsaver = 0.0;
        public double jumpheight = 0.0;
        public boolean springytrigger = false;
        public double chestspeedsaver = 0.0;
        public double legspeedsaver = 0.0;
        public double bootspeedsaver = 0.0;
        public double invchecker = 0.0;
        public boolean bowclumsy = false;
        public boolean held = false;
        public boolean bowlight = false;
        public boolean bowcracked = false;
        public boolean bowpowerful = false;
        public boolean bowlegendary = false;
        public String worthlessname = "\"\"";
        public String worthlessstat1 = "\"\"";

        public void syncPlayerVariables(Entity entity) {
            if (entity instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new PlayerVariablesSyncMessage(this));
            }
        }

        public Tag writeNBT() {
            CompoundTag nbt = new CompoundTag();
            nbt.m_128347_("sword", this.sword);
            nbt.m_128347_("ingot", this.ingot);
            nbt.m_128347_("update1", this.update1);
            nbt.m_128347_("update2", this.update2);
            nbt.m_128379_("successhammer", this.successhammer);
            nbt.m_128379_("successhammer2", this.successhammer2);
            nbt.m_128347_("attackattribute", this.attackattribute);
            nbt.m_128379_("potiontrigger", this.potiontrigger);
            nbt.m_128379_("attackspeed", this.attackspeed);
            nbt.m_128347_("amount", this.amount);
            nbt.m_128379_("guireset", this.guireset);
            nbt.m_128379_("guiopenagain", this.guiopenagain);
            nbt.m_128379_("shieldchecker", this.shieldchecker);
            nbt.m_128347_("shieldspeedsave", this.shieldspeedsave);
            nbt.m_128379_("shieldchecker2", this.shieldchecker2);
            nbt.m_128379_("shieldchecker3", this.shieldchecker3);
            nbt.m_128347_("helmspeedsaver", this.helmspeedsaver);
            nbt.m_128347_("jumpheight", this.jumpheight);
            nbt.m_128379_("springytrigger", this.springytrigger);
            nbt.m_128347_("chestspeedsaver", this.chestspeedsaver);
            nbt.m_128347_("legspeedsaver", this.legspeedsaver);
            nbt.m_128347_("bootspeedsaver", this.bootspeedsaver);
            nbt.m_128347_("invchecker", this.invchecker);
            nbt.m_128379_("bowclumsy", this.bowclumsy);
            nbt.m_128379_("held", this.held);
            nbt.m_128379_("bowlight", this.bowlight);
            nbt.m_128379_("bowcracked", this.bowcracked);
            nbt.m_128379_("bowpowerful", this.bowpowerful);
            nbt.m_128379_("bowlegendary", this.bowlegendary);
            nbt.m_128359_("worthlessname", this.worthlessname);
            nbt.m_128359_("worthlessstat1", this.worthlessstat1);
            return nbt;
        }

        public void readNBT(Tag Tag2) {
            CompoundTag nbt = (CompoundTag)Tag2;
            this.sword = nbt.m_128459_("sword");
            this.ingot = nbt.m_128459_("ingot");
            this.update1 = nbt.m_128459_("update1");
            this.update2 = nbt.m_128459_("update2");
            this.successhammer = nbt.m_128471_("successhammer");
            this.successhammer2 = nbt.m_128471_("successhammer2");
            this.attackattribute = nbt.m_128459_("attackattribute");
            this.potiontrigger = nbt.m_128471_("potiontrigger");
            this.attackspeed = nbt.m_128471_("attackspeed");
            this.amount = nbt.m_128459_("amount");
            this.guireset = nbt.m_128471_("guireset");
            this.guiopenagain = nbt.m_128471_("guiopenagain");
            this.shieldchecker = nbt.m_128471_("shieldchecker");
            this.shieldspeedsave = nbt.m_128459_("shieldspeedsave");
            this.shieldchecker2 = nbt.m_128471_("shieldchecker2");
            this.shieldchecker3 = nbt.m_128471_("shieldchecker3");
            this.helmspeedsaver = nbt.m_128459_("helmspeedsaver");
            this.jumpheight = nbt.m_128459_("jumpheight");
            this.springytrigger = nbt.m_128471_("springytrigger");
            this.chestspeedsaver = nbt.m_128459_("chestspeedsaver");
            this.legspeedsaver = nbt.m_128459_("legspeedsaver");
            this.bootspeedsaver = nbt.m_128459_("bootspeedsaver");
            this.invchecker = nbt.m_128459_("invchecker");
            this.bowclumsy = nbt.m_128471_("bowclumsy");
            this.held = nbt.m_128471_("held");
            this.bowlight = nbt.m_128471_("bowlight");
            this.bowcracked = nbt.m_128471_("bowcracked");
            this.bowpowerful = nbt.m_128471_("bowpowerful");
            this.bowlegendary = nbt.m_128471_("bowlegendary");
            this.worthlessname = nbt.m_128461_("worthlessname");
            this.worthlessstat1 = nbt.m_128461_("worthlessstat1");
        }
    }

    @Mod.EventBusSubscriber
    private static class PlayerVariablesProvider
    implements ICapabilitySerializable<Tag> {
        private final PlayerVariables playerVariables = new PlayerVariables();
        private final LazyOptional<PlayerVariables> instance = LazyOptional.of(() -> this.playerVariables);

        private PlayerVariablesProvider() {
        }

        @SubscribeEvent
        public static void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
            if (event.getObject() instanceof Player && !(event.getObject() instanceof FakePlayer)) {
                event.addCapability(new ResourceLocation("quality_equipment", "player_variables"), (ICapabilityProvider)new PlayerVariablesProvider());
            }
        }

        public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
            return cap == PLAYER_VARIABLES_CAPABILITY ? this.instance.cast() : LazyOptional.empty();
        }

        public Tag serializeNBT() {
            return this.playerVariables.writeNBT();
        }

        public void deserializeNBT(Tag nbt) {
            this.playerVariables.readNBT(nbt);
        }
    }

    public static class MapVariables
    extends SavedData {
        public static final String DATA_NAME = "quality_equipment_mapvars";
        public ItemStack y = ItemStack.f_41583_;
        public String worthlessstat2 = "\"\"";
        public String one = "\"\"";
        public String two = "\"\"";
        public String three = "\"\"";
        public String four = "\"\"";
        static MapVariables clientSide = new MapVariables();

        public static MapVariables load(CompoundTag tag) {
            MapVariables data = new MapVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
            this.y = ItemStack.m_41712_((CompoundTag)nbt.m_128469_("y"));
            this.worthlessstat2 = nbt.m_128461_("worthlessstat2");
            this.one = nbt.m_128461_("one");
            this.two = nbt.m_128461_("two");
            this.three = nbt.m_128461_("three");
            this.four = nbt.m_128461_("four");
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            nbt.m_128365_("y", (Tag)this.y.m_41739_(new CompoundTag()));
            nbt.m_128359_("worthlessstat2", this.worthlessstat2);
            nbt.m_128359_("one", this.one);
            nbt.m_128359_("two", this.two);
            nbt.m_128359_("three", this.three);
            nbt.m_128359_("four", this.four);
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            this.m_77762_();
            if (world instanceof Level && !world.m_5776_()) {
                QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.ALL.noArg(), (Object)new SavedDataSyncMessage(0, this));
            }
        }

        public static MapVariables get(LevelAccessor world) {
            if (world instanceof ServerLevelAccessor) {
                ServerLevelAccessor serverLevelAcc = (ServerLevelAccessor)world;
                return (MapVariables)serverLevelAcc.m_6018_().m_7654_().m_129880_(Level.f_46428_).m_8895_().m_164861_(e -> MapVariables.load(e), MapVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    public static class WorldVariables
    extends SavedData {
        public static final String DATA_NAME = "quality_equipment_worldvars";
        static WorldVariables clientSide = new WorldVariables();

        public static WorldVariables load(CompoundTag tag) {
            WorldVariables data = new WorldVariables();
            data.read(tag);
            return data;
        }

        public void read(CompoundTag nbt) {
        }

        public CompoundTag m_7176_(CompoundTag nbt) {
            return nbt;
        }

        public void syncData(LevelAccessor world) {
            Level level;
            this.m_77762_();
            if (world instanceof Level && !(level = (Level)world).m_5776_()) {
                QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.DIMENSION.with(() -> ((Level)level).m_46472_()), (Object)new SavedDataSyncMessage(1, this));
            }
        }

        public static WorldVariables get(LevelAccessor world) {
            if (world instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)world;
                return (WorldVariables)level.m_8895_().m_164861_(e -> WorldVariables.load(e), WorldVariables::new, DATA_NAME);
            }
            return clientSide;
        }
    }

    @Mod.EventBusSubscriber
    public static class EventBusVariableHandlers {
        @SubscribeEvent
        public static void onPlayerLoggedInSyncPlayerVariables(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerRespawnedSyncPlayerVariables(PlayerEvent.PlayerRespawnEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimensionSyncPlayerVariables(PlayerEvent.PlayerChangedDimensionEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                ((PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables())).syncPlayerVariables((Entity)event.getEntity());
            }
        }

        @SubscribeEvent
        public static void clonePlayer(PlayerEvent.Clone event) {
            event.getOriginal().revive();
            PlayerVariables original = (PlayerVariables)event.getOriginal().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            PlayerVariables clone = (PlayerVariables)event.getEntity().getCapability(PLAYER_VARIABLES_CAPABILITY, null).orElse((Object)new PlayerVariables());
            clone.sword = original.sword;
            clone.ingot = original.ingot;
            clone.update1 = original.update1;
            clone.update2 = original.update2;
            clone.successhammer = original.successhammer;
            clone.successhammer2 = original.successhammer2;
            clone.attackattribute = original.attackattribute;
            clone.potiontrigger = original.potiontrigger;
            clone.attackspeed = original.attackspeed;
            clone.amount = original.amount;
            clone.guireset = original.guireset;
            clone.guiopenagain = original.guiopenagain;
            clone.shieldchecker = original.shieldchecker;
            clone.shieldspeedsave = original.shieldspeedsave;
            clone.shieldchecker2 = original.shieldchecker2;
            clone.shieldchecker3 = original.shieldchecker3;
            clone.helmspeedsaver = original.helmspeedsaver;
            clone.jumpheight = original.jumpheight;
            clone.springytrigger = original.springytrigger;
            clone.chestspeedsaver = original.chestspeedsaver;
            clone.legspeedsaver = original.legspeedsaver;
            clone.bootspeedsaver = original.bootspeedsaver;
            clone.invchecker = original.invchecker;
            clone.bowclumsy = original.bowclumsy;
            clone.held = original.held;
            clone.bowlight = original.bowlight;
            clone.bowcracked = original.bowcracked;
            clone.bowpowerful = original.bowpowerful;
            clone.bowlegendary = original.bowlegendary;
            clone.worthlessname = original.worthlessname;
            clone.worthlessstat1 = original.worthlessstat1;
            if (!event.isWasDeath()) {
                // empty if block
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
            if (!event.getEntity().f_19853_.m_5776_()) {
                MapVariables mapdata = MapVariables.get((LevelAccessor)event.getEntity().f_19853_);
                WorldVariables worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_);
                if (mapdata != null) {
                    QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(0, mapdata));
                }
                if (worlddata != null) {
                    QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
            WorldVariables worlddata;
            if (!event.getEntity().f_19853_.m_5776_() && (worlddata = WorldVariables.get((LevelAccessor)event.getEntity().f_19853_)) != null) {
                QualityEquipmentMod.PACKET_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)event.getEntity()), (Object)new SavedDataSyncMessage(1, worlddata));
            }
        }
    }
}

